/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FilePermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

public final class FilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int ALL = 15;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';
    private static final long serialVersionUID = 7930732926638008763L;

    int getMask() {
        return this.mask;
    }

    public int hashCode() {
        return this.cpath.hashCode();
    }

    private void init(int n2) {
        int n3;
        if ((n2 & 0xF) != n2) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = n2;
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int n4 = this.cpath.length();
        int n5 = n3 = n4 > 0 ? (int)this.cpath.charAt(n4 - 1) : 0;
        if (n3 == 45 && (n4 == 1 || this.cpath.charAt(n4 - 2) == File.separatorChar)) {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --n4);
        } else if (n3 == 42 && (n4 == 1 || this.cpath.charAt(n4 - 2) == File.separatorChar)) {
            this.directory = true;
            this.cpath = this.cpath.substring(0, --n4);
        }
        if (n4 == 0) {
            this.cpath = (String)AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        }
        this.cpath = (String)AccessController.doPrivileged(new PrivilegedAction(this){
            private final FilePermission this$0;
            {
                this.this$0 = filePermission;
            }

            public Object run() {
                try {
                    int n2;
                    File file = new File(FilePermission.access$000(this.this$0));
                    String string = file.getCanonicalPath();
                    if (FilePermission.access$100(this.this$0) && ((n2 = string.length()) == 0 || string.charAt(n2 - 1) != File.separatorChar)) {
                        return string + File.separator;
                    }
                    return string;
                }
                catch (IOException iOException) {
                    return FilePermission.access$000(this.this$0);
                }
            }
        });
    }

    static boolean access$100(FilePermission filePermission) {
        return filePermission.directory;
    }

    boolean impliesIgnoreMask(FilePermission filePermission) {
        if (this.directory) {
            if (this.recursive) {
                if (filePermission.directory) {
                    return filePermission.cpath.length() >= this.cpath.length() && filePermission.cpath.startsWith(this.cpath);
                }
                return filePermission.cpath.length() > this.cpath.length() && filePermission.cpath.startsWith(this.cpath);
            }
            if (filePermission.directory) {
                if (filePermission.recursive) {
                    return false;
                }
                return this.cpath.equals(filePermission.cpath);
            }
            int n2 = filePermission.cpath.lastIndexOf(File.separatorChar);
            if (n2 == -1) {
                return false;
            }
            return this.cpath.length() == n2 + 1 && this.cpath.regionMatches(0, filePermission.cpath, 0, n2 + 1);
        }
        return this.cpath.equals(filePermission.cpath);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(FilePermission.getMask(this.actions));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)object;
        return this.mask == filePermission.mask && this.cpath.equals(filePermission.cpath) && this.directory == filePermission.directory && this.recursive == filePermission.recursive;
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 4) == 4) {
            bl2 = true;
            stringBuffer.append("read");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("write");
        }
        if ((n2 & 1) == 1) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("execute");
        }
        if ((n2 & 8) == 8) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("delete");
        }
        return stringBuffer.toString();
    }

    private static int getMask(String string) {
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        if (string == "read") {
            return 4;
        }
        if (string == "write") {
            return 2;
        }
        if (string == "execute") {
            return 1;
        }
        if (string == "delete") {
            return 8;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n3 < 0) {
            return n2;
        }
        while (n3 != -1) {
            int n4;
            char c2;
            while (n3 != -1 && ((c2 = cArray[n3]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --n3;
            }
            if (!(n3 < 3 || cArray[n3 - 3] != 'r' && cArray[n3 - 3] != 'R' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'a' && cArray[n3 - 1] != 'A' || cArray[n3] != 'd' && cArray[n3] != 'D')) {
                n4 = 4;
                n2 |= 4;
            } else if (!(n3 < 4 || cArray[n3 - 4] != 'w' && cArray[n3 - 4] != 'W' || cArray[n3 - 3] != 'r' && cArray[n3 - 3] != 'R' || cArray[n3 - 2] != 'i' && cArray[n3 - 2] != 'I' || cArray[n3 - 1] != 't' && cArray[n3 - 1] != 'T' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 5;
                n2 |= 2;
            } else if (!(n3 < 6 || cArray[n3 - 6] != 'e' && cArray[n3 - 6] != 'E' || cArray[n3 - 5] != 'x' && cArray[n3 - 5] != 'X' || cArray[n3 - 4] != 'e' && cArray[n3 - 4] != 'E' || cArray[n3 - 3] != 'c' && cArray[n3 - 3] != 'C' || cArray[n3 - 2] != 'u' && cArray[n3 - 2] != 'U' || cArray[n3 - 1] != 't' && cArray[n3 - 1] != 'T' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 7;
                n2 |= 1;
            } else if (!(n3 < 5 || cArray[n3 - 5] != 'd' && cArray[n3 - 5] != 'D' || cArray[n3 - 4] != 'e' && cArray[n3 - 4] != 'E' || cArray[n3 - 3] != 'l' && cArray[n3 - 3] != 'L' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 't' && cArray[n3 - 1] != 'T' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 6;
                n2 |= 8;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl2 = false;
            while (n3 >= n4 && !bl2) {
                switch (cArray[n3 - n4]) {
                    case ',': {
                        bl2 = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n3;
            }
            n3 -= n4;
        }
        return n2;
    }

    FilePermission(String string, int n2) {
        super(string);
        this.init(n2);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        return (this.mask & filePermission.mask) == filePermission.mask && this.impliesIgnoreMask(filePermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }

    static String access$000(FilePermission filePermission) {
        return filePermission.cpath;
    }

    public FilePermission(String string, String string2) {
        super(string);
        this.init(FilePermission.getMask(string2));
    }
}

